/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2025 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

#include <stdio.h>
#include "TIME.h"

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

#define NAME_LENGTH 12

typedef enum
{
	/* Calendrier Julien */
	E_TC_01J = 0,
	E_TC_02J,
	E_TC_03J,
	E_TC_04J,
	E_TC_05J,
	E_TC_06J,
	E_TC_07J,
	E_TC_08J,
	E_TC_09J,
	E_TC_10J,
	E_TC_11J,
	E_TC_12J,
	E_TC_13J,
	E_TC_14J,
	E_TC_15J,
	E_TC_16J,
	E_TC_17J,
	E_TC_18J,
	E_TC_19J,
	E_TC_20J,
	E_TC_21J,
	E_TC_22J,
	E_TC_23J,
	E_TC_24J,
	E_TC_25J,
	E_TC_26J,
	E_TC_27J,
	E_TC_28J,
	E_TC_29J,
	E_TC_30J,

	/* Calendrier Grégorien */
	E_TC_01G,
	E_TC_02G,
	E_TC_03G,
	E_TC_04G,
	E_TC_05G,
	E_TC_06G,
	E_TC_07G,
	E_TC_08G,
	E_TC_09G,
	E_TC_10G,
	E_TC_11G,
	E_TC_12G,
	E_TC_13G,
	E_TC_14G,
	E_TC_15G,
	E_TC_16G,
	E_TC_17G,
	E_TC_18G,
	E_TC_19G,
	E_TC_20G,
	E_TC_21G,
	E_TC_22G,
	E_TC_23G,
	E_TC_24G,
	E_TC_25G,
	E_TC_26G,
	E_TC_27G,
	E_TC_28G,
	E_TC_29G,
	E_TC_30G,

	/* Calendrier UTC */
	E_TC_01U,
	E_TC_02U,
	E_TC_03U,
	E_TC_04U,
	E_TC_05U,
	E_TC_06U,
	E_TC_07U,
	E_TC_08U,
	E_TC_09U,
	E_TC_10U,
	E_TC_11U,
	E_TC_12U,
	E_TC_13U,
	E_TC_14U,
	E_TC_15U,
	E_TC_16U,
	E_TC_17U,
	E_TC_18U,
	E_TC_19U,
	E_TC_20U,
	E_TC_21U,
	E_TC_22U,
	E_TC_23U,
	E_TC_24U,
	E_TC_25U,
	E_TC_26U,
	E_TC_27U,
	E_TC_28U,
	E_TC_29U,
	E_TC_30U,

	E_NB_TC
} tTestCase;

typedef struct
{
	tTestCase testcase;
	char name[NAME_LENGTH];
	tTIME_Timestamp timestamp;
	tTIME_Calendar calendar;
	tTIME_CalendarDate expected;
} tTestCaseParams;

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

#define COM_MSG_MAX_LENGTH (1000)
#define COM_TIMEOUT (1000)

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
UART_HandleTypeDef huart1;

/* USER CODE BEGIN PV */

const tTestCaseParams TEST_CASES[E_NB_TC] =
{
	{ E_TC_01J,  "C2.2.01.J",          0, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 1969, 12, 19,  0,  0,  0}},
	{ E_TC_02J,  "C2.2.02.J", 1755817413, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2025,  8,  8, 23,  3, 33}},
	{ E_TC_03J,  "C2.2.03.J",  627461999, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 1989, 11,  6,  6, 59, 59}},
	{ E_TC_04J,  "C2.2.04.J",  951696000, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2000,  2, 15,  0,  0,  0}},
	{ E_TC_05J,  "C2.2.05.J",  951868799, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2000,  2, 16, 23, 59, 59}},
	{ E_TC_06J,  "C2.2.06.J",  951868800, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2000,  2, 17,  0,  0,  0}},
	{ E_TC_07J,  "C2.2.07.J",  951955199, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2000,  2, 17, 23, 59, 59}},
	{ E_TC_08J,  "C2.2.08.J", 4107456000, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2100,  2, 15,  0,  0,  0}},
	{ E_TC_09J,  "C2.2.09.J", 4107542399, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2100,  2, 15, 23, 59, 59}},
	{ E_TC_10J,  "C2.2.10.J", 4107542400, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2100,  2, 16,  0,  0,  0}},
	{ E_TC_11J,  "C2.2.11.J", 4107628799, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2100,  2, 16, 23, 59, 59}},
	{ E_TC_12J,  "C2.2.12.J",  226022399, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 1977,  2, 15, 23, 59, 59}},
	{ E_TC_13J,  "C2.2.13.J",  226022400, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 1977,  2, 16,  0,  0,  0}},
	{ E_TC_14J,  "C2.2.14.J",   78796800, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 1972,  6, 18,  0,  0,  0}},
	{ E_TC_15J,  "C2.2.15.J",  220924800, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 1976, 12, 19,  0,  0,  0}},
	{ E_TC_16J,  "C2.2.16.J",  252460800, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 1977, 12, 19,  0,  0,  0}},
	{ E_TC_17J,  "C2.2.17.J", 1435708800, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2015,  6, 18,  0,  0,  0}},
	{ E_TC_18J,  "C2.2.18.J", 1366732037, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2013,  4, 10, 15, 47, 17}},
	{ E_TC_19J,  "C2.2.19.J", 1078046773, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2004,  2, 16,  9, 26, 13}},
	{ E_TC_20J,  "C2.2.20.J", 1167609600, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2006, 12, 19,  0,  0,  0}},
	{ E_TC_21J,  "C2.2.21.J", 7289654399, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2200, 12, 16, 23, 59, 59}},
	{ E_TC_22J,  "C2.2.22.J",         42, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 1969, 12, 19,  0,  0, 42}},
	{ E_TC_23J,  "C2.2.23.J",          1, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 1969, 12, 19,  0,  0,  1}},
	{ E_TC_24J,  "C2.2.24.J", 8263890492, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2231, 10, 31, 21,  8, 12}},
	{ E_TC_25J,  "C2.2.25.J",  883612800, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 1997, 12, 19,  0,  0,  0}},
	{ E_TC_26J,  "C2.2.26.J", 1483228800, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2016, 12, 19,  0,  0,  0}},
	{ E_TC_27J,  "C2.2.27.J", 1582948616, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2020,  2, 16,  3, 56, 56}},
	{ E_TC_28J,  "C2.2.28.J",13574577891, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2400,  2, 13,  4,  4, 51}},
	{ E_TC_29J,  "C2.2.29.J",10418889600, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2300,  2, 14,  0,  0,  0}},
	{ E_TC_30J,  "C2.2.30.J", 1760628738, E_CALENDAR_JULIAN   , { true, E_CALENDAR_JULIAN   , 2025, 10,  3, 15, 32, 18}},

	{ E_TC_01G,  "C2.3.01.G",          0, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 1970,  1,  1,  0,  0,  0}},
	{ E_TC_02G,  "C2.3.02.G", 1755817413, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2025,  8, 21, 23,  3, 33}},
	{ E_TC_03G,  "C2.3.03.G",  627461999, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 1989, 11, 19,  6, 59, 59}},
	{ E_TC_04G,  "C2.3.04.G",  951696000, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2000,  2, 28,  0,  0,  0}},
	{ E_TC_05G,  "C2.3.05.G",  951868799, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2000,  2, 29, 23, 59, 59}},
	{ E_TC_06G,  "C2.3.06.G",  951868800, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2000,  3,  1,  0,  0,  0}},
	{ E_TC_07G,  "C2.3.07.G",  951955199, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2000,  3,  1, 23, 59, 59}},
	{ E_TC_08G,  "C2.3.08.G", 4107456000, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2100,  2, 28,  0,  0,  0}},
	{ E_TC_09G,  "C2.3.09.G", 4107542399, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2100,  2, 28, 23, 59, 59}},
	{ E_TC_10G,  "C2.3.10.G", 4107542400, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2100,  3,  1,  0,  0,  0}},
	{ E_TC_11G,  "C2.3.11.G", 4107628799, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2100,  3,  1, 23, 59, 59}},
	{ E_TC_12G,  "C2.3.12.G",  226022399, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 1977,  2, 28, 23, 59, 59}},
	{ E_TC_13G,  "C2.3.13.G",  226022400, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 1977,  3,  1,  0,  0,  0}},
	{ E_TC_14G,  "C2.3.14.G",   78796800, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 1972,  7,  1,  0,  0,  0}},
	{ E_TC_15G,  "C2.3.15.G",  220924800, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 1977,  1,  1,  0,  0,  0}},
	{ E_TC_16G,  "C2.3.16.G",  252460800, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 1978,  1,  1,  0,  0,  0}},
	{ E_TC_17G,  "C2.3.17.G", 1435708800, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2015,  7,  1,  0,  0,  0}},
	{ E_TC_18G,  "C2.3.18.G", 1366732037, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2013,  4, 23, 15, 47, 17}},
	{ E_TC_19G,  "C2.3.19.G", 1078046773, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2004,  2, 29,  9, 26, 13}},
	{ E_TC_20G,  "C2.3.20.G", 1167609600, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2007,  1,  1,  0,  0,  0}},
	{ E_TC_21G,  "C2.3.21.G", 7289654399, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2200, 12, 31, 23, 59, 59}},
	{ E_TC_22G,  "C2.3.22.G",         42, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 1970,  1,  1,  0,  0, 42}},
	{ E_TC_23G,  "C2.3.23.G",          1, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 1970,  1,  1,  0,  0,  1}},
	{ E_TC_24G,  "C2.3.24.G", 8263890492, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2231, 11, 15, 21,  8, 12}},
	{ E_TC_25G,  "C2.3.25.G",  883612800, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 1998,  1,  1,  0,  0,  0}},
	{ E_TC_26G,  "C2.3.26.G", 1483228800, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2017,  1,  1,  0,  0,  0}},
	{ E_TC_27G,  "C2.3.27.G", 1582948616, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2020,  2, 29,  3, 56, 56}},
	{ E_TC_28G,  "C2.3.28.G",13574577891, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2400,  2, 29,  4,  4, 51}},
	{ E_TC_29G,  "C2.3.29.G",10418889600, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2300,  3,  1,  0,  0,  0}},
	{ E_TC_30G,  "C2.3.30.G", 1760628738, E_CALENDAR_GREGORIAN, { true, E_CALENDAR_GREGORIAN, 2025, 10, 16, 15, 32, 18}},

	{ E_TC_01U,  "C2.4.01.U",          0, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 1970,  1,  1,  0,  0,  0}},
	{ E_TC_02U,  "C2.4.02.U", 1755817413, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2025,  8, 21, 23,  3, 33}},
	{ E_TC_03U,  "C2.4.03.U",  627461999, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 1989, 11, 19,  6, 59, 59}},
	{ E_TC_04U,  "C2.4.04.U",  951696000, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2000,  2, 28,  0,  0,  0}},
	{ E_TC_05U,  "C2.4.05.U",  951868799, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2000,  2, 29, 23, 59, 59}},
	{ E_TC_06U,  "C2.4.06.U",  951868800, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2000,  3,  1,  0,  0,  0}},
	{ E_TC_07U,  "C2.4.07.U",  951955199, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2000,  3,  1, 23, 59, 59}},
	{ E_TC_08U,  "C2.4.08.U", 4107456000, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2100,  2, 28,  0,  0,  0}},
	{ E_TC_09U,  "C2.4.09.U", 4107542399, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2100,  2, 28, 23, 59, 59}},
	{ E_TC_10U,  "C2.4.10.U", 4107542400, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2100,  3,  1,  0,  0,  0}},
	{ E_TC_11U,  "C2.4.11.U", 4107628799, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2100,  3,  1, 23, 59, 59}},
	{ E_TC_12U,  "C2.4.12.U",  226022399, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 1977,  2, 28, 23, 59, 59}},
	{ E_TC_13U,  "C2.4.13.U",  226022400, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 1977,  3,  1,  0,  0,  0}},
	{ E_TC_14U,  "C2.4.14.U",   78796800, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 1972,  6, 30, 23, 59, 60}},
	{ E_TC_15U,  "C2.4.15.U",  220924800, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 1976, 12, 31, 23, 59, 60}},
	{ E_TC_16U,  "C2.4.16.U",  252460800, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 1977, 12, 31, 23, 59, 60}},
	{ E_TC_17U,  "C2.4.17.U", 1435708800, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2015,  6, 30, 23, 59, 60}},
	{ E_TC_18U,  "C2.4.18.U", 1366732037, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2013,  4, 23, 15, 47, 17}},
	{ E_TC_19U,  "C2.4.19.U", 1078046773, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2004,  2, 29,  9, 26, 13}},
	{ E_TC_20U,  "C2.4.20.U", 1167609600, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2007,  1,  1,  0,  0,  0}},
	{ E_TC_21U,  "C2.4.21.U", 7289654399, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2200, 12, 31, 23, 59, 59}},
	{ E_TC_22U,  "C2.4.22.U",         42, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 1970,  1,  1,  0,  0, 42}},
	{ E_TC_23U,  "C2.4.23.U",          1, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 1970,  1,  1,  0,  0,  1}},
	{ E_TC_24U,  "C2.4.24.U", 8263890492, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2231, 11, 15, 21,  8, 12}},
	{ E_TC_25U,  "C2.4.25.U",  883612800, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 1997, 12, 31, 23, 59, 60}},
	{ E_TC_26U,  "C2.4.26.U", 1483228800, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2016, 12, 31, 23, 59, 60}},
	{ E_TC_27U,  "C2.4.27.U", 1582948616, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2020,  2, 29,  3, 56, 56}},
	{ E_TC_28U,  "C2.4.28.U",13574577891, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2400,  2, 29,  4,  4, 51}},
	{ E_TC_29U,  "C2.4.29.U",10418889600, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2300,  3,  1,  0,  0,  0}},
	{ E_TC_30U,  "C2.4.30.U", 1760628738, E_CALENDAR_UTC      , { true, E_CALENDAR_UTC      , 2025, 10, 16, 15, 32, 18}}
};

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
static void MX_GPIO_Init(void);
static void MX_USART1_UART_Init(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

bool ComparerDates(const tTIME_CalendarDate * const expected, const tTIME_CalendarDate * const obtained)
{
//	if(obtained->validity != expected->validity) return false;
//	if(obtained->calendar != expected->calendar) return false;
	if(obtained->year   != expected->year  ) return false;
	if(obtained->month  != expected->month ) return false;
	if(obtained->day    != expected->day   ) return false;
	if(obtained->hour   != expected->hour  ) return false;
	if(obtained->minute != expected->minute) return false;
	if(obtained->second != expected->second) return false;
	return true;
}

void SendUartData(const char buffer[COM_MSG_MAX_LENGTH])
{
    unsigned int strl = 0;
    while(buffer[strl] != '\0' && strl < COM_MSG_MAX_LENGTH)
    {
        strl += 1;
    }
    HAL_UART_Transmit(&huart1, (const unsigned char *)buffer, strl, COM_TIMEOUT);
}

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{

  /* USER CODE BEGIN 1 */

	tTestCase tc;
	tTIME_CalendarDate obtained;
	char buffer[COM_MSG_MAX_LENGTH];

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_USART1_UART_Init();
  /* USER CODE BEGIN 2 */

  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
//  while (1)
  {
    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */

	  for(tc = 0 ; tc < E_NB_TC ; ++tc)
	  {
		  obtained = TIME_ComputeDate(TEST_CASES[tc].calendar, TEST_CASES[tc].timestamp);
		  obtained.month += 1;
		  obtained.day   += 1;

		  switch(tc)
		  {
		  case E_TC_01J: SendUartData("-------- Tests calendrier Julien -----------\n"); break;
		  case E_TC_21J: SendUartData(". . . . . . . . . . . . . . . . . . . . . . \n"); break;
		  case E_TC_01G: SendUartData("-------- Tests calendrier Gregorien --------\n"); break;
		  case E_TC_21G: SendUartData(". . . . . . . . . . . . . . . . . . . . . . \n"); break;
		  case E_TC_01U: SendUartData("-------- Tests calendrier UTC --------------\n"); break;
		  case E_TC_21U: SendUartData(". . . . . . . . . . . . . . . . . . . . . . \n"); break;
		  default: break;
		  }

		  if(ComparerDates(&(TEST_CASES[tc].expected), &obtained))
		  {
			  snprintf(buffer, COM_MSG_MAX_LENGTH, "Test %s : OK\n", TEST_CASES[tc].name);
		  }
		  else
		  {
			  snprintf
			  (
				  buffer, COM_MSG_MAX_LENGTH,
				  "Test %s : ERREUR (attendu : %04d/%02d/%02d %02d:%02d:%02d; obtenu : %04d/%02d/%02d %02d:%02d:%02d)\n",
				  TEST_CASES[tc].name,
				  TEST_CASES[tc].expected.year, TEST_CASES[tc].expected.month , TEST_CASES[tc].expected.day   ,
				  TEST_CASES[tc].expected.hour, TEST_CASES[tc].expected.minute, TEST_CASES[tc].expected.second,
				  obtained.year, obtained.month , obtained.day   ,
				  obtained.hour, obtained.minute, obtained.second
			  );
		  }
		  SendUartData(buffer);
	  }
	  SendUartData("--------------------------------------------\n");
  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};
  RCC_PeriphCLKInitTypeDef PeriphClkInit = {0};

  /** Configure the main internal regulator output voltage
  */
  __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.HSICalibrationValue = RCC_HSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSI;
  RCC_OscInitStruct.PLL.PLLMUL = RCC_PLLMUL_4;
  RCC_OscInitStruct.PLL.PLLDIV = RCC_PLLDIV_2;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_1) != HAL_OK)
  {
    Error_Handler();
  }
  PeriphClkInit.PeriphClockSelection = RCC_PERIPHCLK_USART1;
  PeriphClkInit.Usart1ClockSelection = RCC_USART1CLKSOURCE_PCLK2;
  if (HAL_RCCEx_PeriphCLKConfig(&PeriphClkInit) != HAL_OK)
  {
    Error_Handler();
  }
}

/**
  * @brief USART1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_USART1_UART_Init(void)
{

  /* USER CODE BEGIN USART1_Init 0 */

  /* USER CODE END USART1_Init 0 */

  /* USER CODE BEGIN USART1_Init 1 */

  /* USER CODE END USART1_Init 1 */
  huart1.Instance = USART1;
  huart1.Init.BaudRate = 9600;
  huart1.Init.WordLength = UART_WORDLENGTH_8B;
  huart1.Init.StopBits = UART_STOPBITS_1;
  huart1.Init.Parity = UART_PARITY_NONE;
  huart1.Init.Mode = UART_MODE_TX_RX;
  huart1.Init.HwFlowCtl = UART_HWCONTROL_NONE;
  huart1.Init.OverSampling = UART_OVERSAMPLING_16;
  huart1.Init.OneBitSampling = UART_ONE_BIT_SAMPLE_DISABLE;
  huart1.AdvancedInit.AdvFeatureInit = UART_ADVFEATURE_NO_INIT;
  if (HAL_UART_Init(&huart1) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN USART1_Init 2 */

  /* USER CODE END USART1_Init 2 */

}

/**
  * @brief GPIO Initialization Function
  * @param None
  * @retval None
  */
static void MX_GPIO_Init(void)
{
  /* USER CODE BEGIN MX_GPIO_Init_1 */

  /* USER CODE END MX_GPIO_Init_1 */

  /* GPIO Ports Clock Enable */
  __HAL_RCC_GPIOA_CLK_ENABLE();

  /* USER CODE BEGIN MX_GPIO_Init_2 */

  /* USER CODE END MX_GPIO_Init_2 */
}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}
#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
